<?php
session_start();
include 'includes/auth.php';
include 'includes/db.php';

// Search string
$search = mysqli_real_escape_string($conn, $_GET['search'] ?? '');

// Base WHERE clause
$where = "WHERE payment_status='Expired' AND banned = 0";

// Apply search filters
if (!empty($search)) {
    $where .= " AND (
        CAST(member_number AS CHAR) = '$search' OR
        CONCAT(first_name, ' ', surname) LIKE '%$search%' OR 
        nfc_uid LIKE '%$search%'
    )";
}


// Pagination
$limit = 15;
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
if ($page < 1) $page = 1;
$offset = ($page - 1) * $limit;

// Count
$count_sql = "SELECT COUNT(*) AS total FROM members $where";
$total_members = mysqli_fetch_assoc(mysqli_query($conn, $count_sql))['total'];
$total_pages = ceil($total_members / $limit);

// Fetch
$sql = "SELECT * FROM members $where ORDER BY expiry_date DESC LIMIT $offset, $limit";
$result = mysqli_query($conn, $sql);
?>


<?php include 'includes/header.php'; ?>

<style>
    td, th { white-space: nowrap; }
    @media (max-width: 576px) { table { font-size: 0.9rem; } }
</style>

<h2>Expired Members</h2>

<form class="row mb-3" method="get">
    <div class="col-md-4 col-sm-8 mb-2">
        <input type="text" name="search" value="<?php echo htmlspecialchars($search); ?>" class="form-control" placeholder="Search by name or member number">
    </div>
    <div class="col-md-2 col-sm-4 mb-2">
        <button class="btn btn-primary w-100" type="submit"><i class="fas fa-search"></i> Search</button>
    </div>
</form>

<div class="table-responsive">
    <table class="table table-bordered table-striped table-sm">
        <thead class="table-dark">
            <tr>
<th>Member #</th>
                <th>Name</th>
                <th>Phone</th>
                <th>Expiry Date</th>
                <th>Payment Status</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php if (mysqli_num_rows($result) == 0) { ?>
                <tr><td colspan="6" class="text-center">No expired members found</td></tr>
            <?php } else { while($row = mysqli_fetch_assoc($result)) { 
                $expiry = ($row['expiry_date'] && $row['expiry_date'] != '0000-00-00') 
                    ? date('d/m/Y', strtotime($row['expiry_date'])) 
                    : '';
            ?>
                <tr class="table-danger">
<td><?= htmlspecialchars($row['member_number']) ?></td>
                    <td><?php echo $row['first_name'].' '.$row['surname']; ?></td>
                    <td><?php echo $row['phone']; ?></td>
                    <td><?php echo $expiry; ?></td>
                    <td><?php echo $row['payment_status']; ?></td>
                    <td>
                        <a href="edit_member.php?id=<?php echo $row['id']; ?>" class="btn btn-sm btn-warning" title="Edit">
                            <i class="fas fa-edit"></i>
                        </a>
                       <a href="view_member.php?id=<?php echo $row['id']; ?>" class="btn btn-info btn-sm">
        View
    </a>
                    </td>
                </tr>
            <?php }} ?>
        </tbody>
    </table>
</div>

<!-- Pagination -->
<nav>
  <ul class="pagination">
    <?php if ($page > 1): ?>
      <li class="page-item"><a class="page-link" href="?search=<?php echo urlencode($search); ?>&page=<?php echo $page-1; ?>">Previous</a></li>
    <?php endif; ?>

    <?php
    $start = max(1, $page - 2);
    $end = min($total_pages, $page + 2);

    if ($start > 1) {
        echo '<li class="page-item"><a class="page-link" href="?search='.urlencode($search).'&page=1">1</a></li>';
        if ($start > 2) echo '<li class="page-item disabled"><span class="page-link">...</span></li>';
    }

    for ($i = $start; $i <= $end; $i++) {
        $active = ($i == $page) ? 'active' : '';
        echo '<li class="page-item '.$active.'"><a class="page-link" href="?search='.urlencode($search).'&page='.$i.'">'.$i.'</a></li>';
    }

    if ($end < $total_pages) {
        if ($end < $total_pages - 1) echo '<li class="page-item disabled"><span class="page-link">...</span></li>';
        echo '<li class="page-item"><a class="page-link" href="?search='.urlencode($search).'&page='.$total_pages.'">'.$total_pages.'</a></li>';
    }
    ?>

    <?php if ($page < $total_pages): ?>
      <li class="page-item"><a class="page-link" href="?search=<?php echo urlencode($search); ?>&page=<?php echo $page+1; ?>">Next</a></li>
    <?php endif; ?>
  </ul>
</nav>

<?php include 'includes/footer.php'; ?>
